//
//  MyDocument.h
//  Composer
//
//  Created by Alykhan Jetha on 04/06/2005.
//  Copyright Marketcircle Inc. 2005 . All rights reserved.
//

#import <MCApplication/MCDocument.h>

@class MCReportLayout;
@class MCReportTextArea;
@class MCReportWrapper;
@class MCReportTable;

@interface MCReportDocument : MCDocument
{
	MCReportLayout *reportLayout;
	NSMutableDictionary *reportInfo;
	NSFileWrapper *fileWrapper;
	id representedObject;

}

@property (retain) id representedObject;

/*
 
 Set a creation hint dictionary for right before you call the create document method. This dictionary should have a HelperClassname. This class run as a sheet. The purpose is to have assistant like things. The helper class should be subclass of MCWindowController and it should respond to setCreationHintArguments:
 
 The dictionary should have two keys
 
    HelperClassname
    Arguments
 
 The arguments are passed to the helper before it is run as a sheet.
 
 The creation hint is automatically cleared when the document is created.
 
 */
+ (void)setReportDocumentCreationHint:(NSDictionary *)aDictionary;
+ (NSDictionary *)reportDocumentCreationHint;
+ (void)clearReportDocumentCreationHint;

- (void)postRefreshToWindowControllers;

- (MCReportLayout *)reportLayout;
- (void)setReportLayout:(MCReportLayout *)aReportLayout;
- (void)resetReportLayoutWith:(MCReportLayout *)aReportLayout;
- (void)takeUserInputsFromWrapper:(MCReportWrapper *)aWrapper;
- (void)resetAndTakeComponentsFromOtherWrapper:(MCReportWrapper *)aWrapper;
- (void)resetAll;

// shortcuts
- (NSString *)reportBehavior;
- (NSString *)entityClassKind;

- (NSMutableDictionary *)reportInfo;
- (void)setReportInfo:(NSMutableDictionary *)aReportInfo;

- (NSFileWrapper *)fileWrapper;
- (void)setFileWrapper:(NSFileWrapper *)aFileWrapper;


- (NSSize)layoutDocumentSize;
- (NSRect)layoutDocumentRect;


- (IBAction)showRenderPreview:(id)sender;

- (void)runDynamicTextEditorForTextArea:(MCReportTextArea *)anArea inWindow:(NSWindow *)aWindow;;

- (void)runDefaultEditorForTable:(MCReportTable *)aTable afterDragCreate:(id <NSDraggingInfo>)dragInfo;

@end
